#ifndef _DEFINED_NetWorkDLS_Database_System_Core_Header
#define _DEFINED_NetWorkDLS_Database_System_Core_Header
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define DllImport         extern "C" __declspec( dllimport )

#define MAXDATASIZE      1048576
#define MAXROWSPERCOLUMB 1000000
#define MAXCOLUMBS       1000000
#define MINROWSPERCOLUMB 1
#define MINCOLUMBS       1

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

struct _NDBSColumb{
    char **Row;     // Row Data              | Row[Row]      = "Row Data";
    int *Length;    // Length to row data    | Length[Row]   = 9;

    char *Name;     // Name of columb        | Name          = "Columb Name";
    int NameLength; // Length of columb name | NameLength    = 11;
    int Rows;       // Rows in this columb   | Rows          = 1255;
};

struct _NDataBaseSystem{
    int MaxRowsPerColumb; //- Max rows per columb    | MaxRowsPerColumb = 1000;
    int MaxColumbs;       //- Max columbs            | MaxColumbs       = 100
    int Columbs;          //- Current columbs in DB  | Columbs          = 57;
    _NDBSColumb *Columb;   //- Columbs structure      | Columb[Columb Number]
};

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DllImport int VAddEntryByColumbPosition(struct _NDataBaseSystem *, int, void *, int);
DllImport int VAddEntryByColumbName(struct _NDataBaseSystem *, char *, void *, int);
DllImport int VRetreiveDataByColumbPosition(struct _NDataBaseSystem *, int, int, void *);
DllImport int VRetreiveDataByColumbName(struct _NDataBaseSystem *, char *, int, void *);

DllImport int InitializeNDBS(struct _NDataBaseSystem *, int, int);
DllImport int FreeNDBS(struct _NDataBaseSystem *);

DllImport int AddColumb(struct _NDataBaseSystem *, char *, int);
DllImport int ColumbNameToColumbPosition(struct _NDataBaseSystem *, char *);
DllImport int GetMostRows(struct _NDataBaseSystem *);

DllImport int DeleteRowByColumbPosition(struct _NDataBaseSystem *, int, int);
DllImport int DeleteRowByColumbName(struct _NDataBaseSystem *, char *, int);

DllImport int AddEntryByColumbPosition(struct _NDataBaseSystem *, int, char *, int);
DllImport int AddEntryByColumbName(struct _NDataBaseSystem *, char *, char *, int);

DllImport int RetreiveDataLengthByColumbPosition(struct _NDataBaseSystem *, int, int);
DllImport int RetreiveDataLengthByColumbName(struct _NDataBaseSystem *, char *, int);

DllImport int SearchRowDataByColumbPosition(struct _NDataBaseSystem *, int, char *);
DllImport int SearchRowDataByColumbName(struct _NDataBaseSystem *, char *, char *);

DllImport int RetreiveDataByColumbPosition(struct _NDataBaseSystem *, int, int, char *);
DllImport int RetreiveDataByColumbName(struct _NDataBaseSystem *, char *, int, char *);

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

